
#====================
#dataset
import pandas as pd
import numpy as np

# #===========================================================
# #===========================================================

#Obtain data from Excel file
path1='Planilla_pruebas.xlsx'

Data_df = pd.read_excel(path1) 

#Change format to numpy
Data=Data_df.to_numpy()

XX = Data[3:22,:] 
XY = Data[23:30,:]
XZ = Data[31:,:]

Data = np.concatenate((XX,XY,XZ),axis=0)

#Input variables
X = Data[:,1:6]
#output variable
y = Data[:,6]

# Coding the MiniBESTest into a binary varible
y_codif=np.zeros([y.shape[0]])

thresh=22 

for n in range(0,y.shape[0]):
    
    if y[n] < thresh:
        y_codif[n]=0       
    else:
        y_codif[n]=1     
        
y = y_codif
# ===========================================================
#===========================================================

#'varia' from 0 to 4, controls on which feature the FDR is calculated
varia=4
varia_name = ["Edu_level", "Age", "TMT", "DSB", "SCWI"]

print('FDR value for feature ' + varia_name[varia])

#samples of the feature that belong to class 0 or class 1 =====================
clase_0_pos=np.where(y==0)
clase_1_pos=np.where(y==1)

#class 0
print('-----class 0-----')
media_0=np.mean(X[clase_0_pos[0][:],varia])
var_0=np.var(X[clase_0_pos[0][:],varia])
print("mean = %.3f" % media_0 + " var = %.3f" % var_0)

#class 1
print('-----class 1-----')
media_1=np.mean(X[clase_1_pos[0][:],varia])
var_1=np.var(X[clase_1_pos[0][:],varia])
print("mean = %.3f" % media_1 + " var = %.3f" % var_1)

#Fisher discriminat ratio
print('-----FDR value-----')
FDR=np.power(media_0-media_1,2)/(var_0+var_1)
print("FDR = %.3f" % FDR)






